﻿using Emgu.CV;
using Emgu.CV.CvEnum;
using Emgu.CV.Util;
using System;
using System.Collections.Generic;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Controls;
using System.Windows.Ink;
using System.Windows.Input;

namespace WpfApp1.Structure
{
    internal class SymbolTemplate
    {
        public static Dictionary<string, Symbol> d_Templates = new Dictionary<string, Symbol>();

        public static void GetSymbolTemplates(string path, Canvas video_text)
        {
            d_Templates = GetTemplates(path, video_text);
        }

        //仅支持Node模板
        private static Dictionary<string, Symbol> GetTemplates(string templatesDir, Canvas canvas)
        {
            Dictionary<string, Symbol> d_Templates = new Dictionary<string, Symbol>();
            // 获取所有支持的图像格式文件
            string[] filePaths = Directory.GetFiles(templatesDir, "*.*", SearchOption.TopDirectoryOnly)
                .Where(f => f.EndsWith(".jpg") || f.EndsWith(".jpeg") || f.EndsWith(".png") || f.EndsWith(".bmp")).ToArray();
            foreach (string path in filePaths)
            {
                string name = Path.GetFileNameWithoutExtension(path);
                Mat image = CvInvoke.Imread(path, Emgu.CV.CvEnum.ImreadModes.Grayscale);
                VectorOfVectorOfPoint contours = new VectorOfVectorOfPoint();
                CvInvoke.FindContours(image, contours, null, RetrType.List, ChainApproxMethod.ChainApproxTc89Kcos);
                //仅支持单实例
                if (contours.Size > 1)
                {
                    throw new Exception("too much instances");
                }

                Rectangle bbox = CvInvoke.BoundingRectangle(contours[0]);
                double centerX = bbox.X + bbox.Width / 2;
                double centerY = bbox.Y + bbox.Height / 2;
                double area = CvInvoke.ContourArea(contours[0]);

                StrokeCollection strokes = new StrokeCollection();
                StylusPointCollection points = new StylusPointCollection();
                for (int i = 0; i < contours[0].Size; i++)
                {
                    points.Add(new StylusPoint(contours[0][i].X, contours[0][i].Y));
                }
                points.Add(new StylusPoint(contours[0][0].X, contours[0][0].Y));
                Stroke stroke = new Stroke(points);
                stroke.DrawingAttributes.Color = SymbolColor.d_Colors[SymbolColor.d_CategoryColor[name]];
                strokes.Add(stroke);

                Node node = new Node(-1, canvas);
                node.text = "";
                node.category = name;
                node.color = "";
                node.center = new double[] { centerX, centerY };
                node.area = area;
                node.strokes = strokes;
                node.text_thumb.Visibility = System.Windows.Visibility.Collapsed;
                d_Templates.Add(name, node);
            }
            return d_Templates;
        }
    }
}
